DROP VIEW bouwplan_view;

CREATE OR REPLACE VIEW bouwplan_view AS 
 SELECT b.id, b.the_geom, b.naam, b.gebruikgegevensid, b.aanduidingid,
        CASE ( SELECT v.voortgangstatusid
               FROM bouwplanvoortgang v
              WHERE v.bouwplanid = b.id AND v.voortgangsoortid = 1)
            WHEN 1 THEN '#009900'::text
            WHEN 2 THEN '#ff6600'::text
            WHEN 3 THEN '#ff0000'::text
            ELSE '#C0C0C0'::text
        END AS voortgang, b.gemeenteid, g.regioid, r.provincieid, b.statusprojectid
   FROM bouwplan b
   LEFT JOIN gemeente g ON b.gemeenteid = g.id
   LEFT JOIN regio r ON g.regioid = r.id
  WHERE b.statusprojectid <> 11 AND b.the_geom IS NOT NULL
  ORDER BY b.id;

ALTER TABLE bouwplan_view
  OWNER TO rwbp;

